% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{SequentialLineMin}
\alias{SequentialLineMin}
\title{Minimize a function of r variables by sequential univariate searches.}
\usage{
SequentialLineMin(fcn, bounds, v0, tol = .Machine$double.eps^0.25)
}
\arguments{
\item{fcn}{A function with taking an r-vector as its first argument: call as \code{fcn(v,...)}.}

\item{bounds}{A 2-vector giving the upper and lower limits for elements of a solution.}

\item{v0}{A starting solution, with increasing elements. An r-vector. Not used if r == 1.}

\item{tol}{Tolerance passed to \code{optimize}.}
}
\value{
a list with elements:
\item{\code{minimizer}}{An r-vector containing the solution.}
\item{\code{minimum}}{The objective function value at the solution.}
}
\description{
The function seeks to minimize \code{fcn}, a scalar function of \eqn{r} variables.  \code{v0}
is a starting solution and \code{bounds} is a 2-vector giving upper and lower limits for
elements of the solution.
}
\details{
This algorithm is designed to search for solutions of the form \eqn{v = [v_1 v_2 \ldots v_r]},
where \code{bounds(1)} \eqn{< v_1 < v_2 < ... < v_r <} \code{ bounds(2)}. It loops through the solution vector
one variable at a time, and does a 1-D line search using \code{optimize()} for an improving
value of that variable.  So when optimizing \eqn{v_i}, it searches the interval \eqn{(v_{i-1},
v_{i+1})} to maintain the increasing nature of \eqn{v}. The overall search terminates once a
pass through all \eqn{r} elements of \eqn{v} fails to produce any changes to \eqn{v}.
}
\examples{
fcn <- function(v) (v[1]+1)^2 + (v[2]-1)^2
SequentialLineMin(fcn, c(-5,5), c(-3,3))

}
