% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SceToJMat}
\alias{SceToJMat}
\title{SceToJMat}
\usage{
SceToJMat(
  M,
  fname,
  rownames = NULL,
  colnames = NULL,
  mtype = "sparse",
  ctype = "raw",
  valuetype = "float",
  transpose = FALSE,
  comment = ""
)
}
\arguments{
\item{M}{The numeric matrix (extracted from the sce object as counts(theobject) or otherwise directly from the sce object).}

\item{fname}{A string with the name of the binary output file}

\item{rownames}{The vector of strings with the row names (extracted from the sce object, or set by the user). Default: empty vector (column names will be extracted from the matrix dimnames, if present)}

\item{colnames}{The vector of strings with the column names (extracted from the sce object, or set by the user). Default: empty vector (row names will be extracted from the matrix dimnames, if present)}

\item{mtype}{A string to indicate the matrix type: 'full' or 'sparse'. Default: 'sparse'}

\item{ctype}{The string 'raw' or 'log1' to write raw counts or log(counts+1), or the normalized versions, 'rawn' and 'log1n', which normalize ALWAYS BY COLUMNS (before transposition, if requested to transpose). Default: raw}

\item{valuetype}{The data type to store the matrix. It must be one of the strings 'uint32', 'float' or 'double'. Default: float}

\item{transpose}{Boolean to indicate if the matrix should be transposed before writing. See Details for a comment about this. Default: FALSE}

\item{comment}{A comment to be stored with the matrix. Default: "" (no comment)}
}
\value{
No return value, called for side effects (creates a file)
}
\description{
Gets a numeric matrix of counts in the single cell experiment (sce) format and writes it to a disk file in the jmatrix binary format.\cr
To use this function you will have to extract yourself the matrix of counts (and may be the vectors of row names and column names) from the sce
or other object type. Plase, see the Details section
}
\details{
The package BiocGenerics offers a facility to get the counts matrix, the function `counts, so usually you may load this package and use
counts(your_sce_object) as first argument. But sometimes not, and for example in the DuoClustering, you have\cr 
\cr
M<-your_object@assays$data@listData$counts\cr
\cr
to extract the counts matrix but in splatter you would have\cr
\cr
M<-your_object@assays@data@listData$counts\cr
\cr
(which is not exactly the same...)\cr

The message, unfortunately, is: extract the data inspecting the internal structure of the object in the package that provided the data you are using.\cr
We assume, nevertheless, that if the matrix is M,\cr
attr(M,"dim")[1] is the number of rows (genes)\cr
attr(M,"dim")[2] is the number of columns (cells)\cr
attr(M,"dimnames")[1] is the vector of row names (names of genes)\cr
attr(M,"dimnames")[2] is the vector of colums names (names of cells)\cr
But if the matrix has not row or column names, or even if it has but you want to overwrite them, you can pass a value for parameter rownames or colnames
that will be honored. If you do not pass one or both the function will try to get them from the matrix attributes, as stated before. If they do not exist
as attributes in the matrix, they will be left empty.

The parameter transpose has the default value of FALSE. But don't forget to set it to TRUE if you want the cells
(which in single cell common practice are by columns) to be written by rows. This will be needed later to calculate
the dissimilarity matrix, if this is the next step of your workflow. See help of CalcAndWriteDissimilarityMatrix.
}
\examples{
# Sorry, we cannot provide an example here, since it would need the load of the splatter package.
# Please, see the vignette for examples
}
