% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch.R
\name{set.theme}
\alias{set.theme}
\title{Create settings for Rmarkdown page}
\usage{
set.theme(
  theme = c("default", "wide"),
  color = NULL,
  header.sticky = TRUE,
  header.image = NULL,
  header.color = NULL,
  list.group.icon = c("circle", "square", "star", "arrow", "quote", "heart"),
  font.family = NULL,
  font.color = NULL
)
}
\arguments{
\item{theme}{theme to use for the page}

\item{color}{primary color for the theme}

\item{header.sticky}{make header sticky, TRUE or FALSE}

\item{header.image}{include image such as logo in the header}

\item{header.color}{color for the title of the page}

\item{list.group.icon}{set a list group icon}

\item{font.family}{set the font family}

\item{font.color}{set the global text color}
}
\value{
styles for themeing the page
}
\description{
Set options for the styling of the Rmarkdown theme to use on the page
}
\section{Demos for sciRmdTheme}{

More examples and demo pages for are located at this link -
\url{https://github.com/oobianom/sciRmdTheme}.
}

\examples{
set.theme("wide")
set.theme(
theme = "default",
color = "purple",
header.sticky=TRUE,
header.image="logo.png",
list.group.icon = "arrow",
font.family = "Arial",
font.color = "#333333",
header.color = "darkblue"
)

}
