% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_extract.R
\name{read_xl_sheets}
\alias{read_xl_sheets}
\title{Read All Sheets from an Excel Workbook}
\usage{
read_xl_sheets(file_name = NULL)
}
\arguments{
\item{file_name}{(character) Name of (and path to) the Excel workbook}
}
\value{
(list) One tibble per sheet in the Excel workbook stored as separate elements in a list
}
\description{
Retrieves all of the sheets in a given Microsoft Excel workbook and stores them as elements in a list. Note that the guts of this function were created by the developers of `readxl::read_excel()` and we merely created a wrapper function to invoke their work more easily.
}
\examples{
# Read in each sheet as an element in a list
read_xl_sheets(file_name = system.file("extdata", "excel_book.xlsx", package = "scicomptools"))

}
