% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scoring}
\alias{scoring}
\title{Scoring a dataset with class based on a scalling logic to arrive at final score}
\usage{
scoring(base, target, scalling)
}
\arguments{
\item{base}{input dataframe with classes same as scalling logic}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{scalling}{dataframe of class scalling with atleast two columns - Variable, Category, Coefficient, D(i,j)_hat, Score}
}
\value{
The function returns a dataframe with classes converted to scores and the final score for each record in the input dataframe.
}
\description{
The function takes the data, with each variable as class. The dataframe of class scalling is used to convert the class into scores and finally arrive at the row level final scores by adding up the score values.
}
\examples{
data <- iris
suppressWarnings(RNGversion('3.5.0'))
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
x <- c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width")
iv_table_list <- iv_table(base = data,target = "Y",num_var_name = x,cat_var_name = "Species")
num_cat <- num_to_cat(base = data,num_woe_table = iv_table_list$num_woe_table)
log_model <- glm(Y ~ ., data = num_cat, family = "binomial")
scaling_tab <- scalling(base = num_cat,target = "Y",model = log_model)
score_tab <- scoring(base = num_cat,target = "Y",scalling = scaling_tab)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
