% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_functions.R
\name{peak_functions}
\alias{peak_functions}
\alias{score_type1}
\alias{score_type2}
\alias{score_type3}
\title{Peak Functions for Peak Detection in Univariate Time Series}
\usage{
score_type1(data, w, boundary = "reflecting")

score_type2(data, w, boundary = "reflecting")

score_type3(data, w, boundary = "reflecting")
}
\arguments{
\item{data}{a numeric vector. Length of data must be greater than 1.}

\item{w}{window size. w must be odd and greater than 2 and smaller than double length of data.}

\item{boundary}{determines how data points in the beginning and end of the time series will be treated. "reflecting", "r": reflecting boundary condition, "periodic", "p": periodic boundary condition, "discard", "d", discarding data points in the beginning and end of the time series. See the vignette "Introduction to scorepeak" for detail.}
}
\value{
a numeric vector
}
\description{
scorepeak package provides several types of peak function. See the vignette "Introduction to scorepeak" for detail.
}
\examples{
data("ecgca102")
plot(ecgca102, type = "l", ylim = c(-0.38, 0.53))
points(seq(length(ecgca102)), score_type1(ecgca102, 51), col = "red", type = "l")
points(seq(length(ecgca102)), score_type2(ecgca102, 51), col = "blue", type = "l")
points(seq(length(ecgca102)), score_type3(ecgca102, 51), col = "green", type = "l")
}
\author{
Shota Ochi
}
