test_that("max_neighbors",
{
  correct_max_neighbors_l_r <- c(1, 4, 1)
  correct_max_neighbors_r_r <- c(1, 4, 1)
  correct_max_neighbors_b_r <- c(1, 4, 1)
  correct_max_neighbors_a_r <- c(2, 5, 3)
  expect_equal(max_neighbors(b, w, "l")[idx_lp], correct_max_neighbors_l_r)
  expect_equal(max_neighbors(b, w, "r")[idx_lp], correct_max_neighbors_r_r)
  expect_equal(max_neighbors(b, w, "b")[idx_lp], correct_max_neighbors_b_r)
  expect_equal(max_neighbors(b, w, "a")[idx_lp], correct_max_neighbors_a_r)
  
  correct_max_neighbors_l_p <- c(3, 4, 1)
  correct_max_neighbors_r_p <- c(1, 4, 2)
  correct_max_neighbors_b_p <- c(3, 4, 2)
  correct_max_neighbors_a_p <- c(3, 5, 3)
  expect_equal(max_neighbors(b, w, "l", "p")[idx_lp], correct_max_neighbors_l_p)
  expect_equal(max_neighbors(b, w, "r", "p")[idx_lp], correct_max_neighbors_r_p)
  expect_equal(max_neighbors(b, w, "b", "p")[idx_lp], correct_max_neighbors_b_p)
  expect_equal(max_neighbors(b, w, "a", "p")[idx_lp], correct_max_neighbors_a_p)
  
  correct_max_neighbors_l_d <- c(NA, 4, NA)
  correct_max_neighbors_r_d <- c(NA, 4, NA)
  correct_max_neighbors_b_d <- c(NA, 4, NA)
  correct_max_neighbors_a_d <- c(NA, 5, NA)
  expect_equal_na_allowed(max_neighbors(b, w, "l", "d")[idx_lp], correct_max_neighbors_l_d)
  expect_equal_na_allowed(max_neighbors(b, w, "r", "d")[idx_lp], correct_max_neighbors_r_d)
  expect_equal_na_allowed(max_neighbors(b, w, "b", "d")[idx_lp], correct_max_neighbors_b_d)
  expect_equal_na_allowed(max_neighbors(b, w, "a", "d")[idx_lp], correct_max_neighbors_a_d)
  
  expect_equal(max_neighbors(a, w, "left", "r"), max_neighbors(a, w, "l", "r"))
  expect_equal(max_neighbors(a, w, "right", "r"), max_neighbors(a, w, "r", "r"))
  expect_equal(max_neighbors(a, w, "both", "r"), max_neighbors(a, w, "b", "r"))
  expect_equal(max_neighbors(a, w, "all", "r"), max_neighbors(a, w, "a", "r"))
  expect_error(max_neighbors(a, w, side = NULL))
  expect_error(max_neighbors(a, w, side = "oh!"))
})
