test_that("mean_neighbors",
{
  correct_mean_neighbors_l_r <- c(1.0, 3.5, 1.0)
  correct_mean_neighbors_r_r <- c(1.0, 3.5, 1.0)
  correct_mean_neighbors_b_r <- c(1.0, 3.5, 1.0)
  correct_mean_neighbors_a_r <- c(1.2, 3.8, 1.4)
  expect_equal(mean_neighbors(b, w, "l")[idx_lp], correct_mean_neighbors_l_r)
  expect_equal(mean_neighbors(b, w, "r")[idx_lp], correct_mean_neighbors_r_r)
  expect_equal(mean_neighbors(b, w, "b")[idx_lp], correct_mean_neighbors_b_r)
  expect_equal(mean_neighbors(b, w, "a")[idx_lp], correct_mean_neighbors_a_r)
  
  correct_mean_neighbors_l_p <- c(2.0, 3.5, 1.0)
  correct_mean_neighbors_r_p <- c(1.0, 3.5, 1.5)
  correct_mean_neighbors_b_p <- c(1.50, 3.50, 1.25)
  correct_mean_neighbors_a_p <- c(1.6, 3.8, 1.6)
  expect_equal(mean_neighbors(b, w, "l", "p")[idx_lp], correct_mean_neighbors_l_p)
  expect_equal(mean_neighbors(b, w, "r", "p")[idx_lp], correct_mean_neighbors_r_p)
  expect_equal(mean_neighbors(b, w, "b", "p")[idx_lp], correct_mean_neighbors_b_p)
  expect_equal(mean_neighbors(b, w, "a", "p")[idx_lp], correct_mean_neighbors_a_p)
  
  correct_mean_neighbors_l_d <- c(NA, 3.5, NA)
  correct_mean_neighbors_r_d <- c(NA, 3.5, NA)
  correct_mean_neighbors_b_d <- c(NA, 3.5, NA)
  correct_mean_neighbors_a_d <- c(NA, 3.8, NA)
  expect_equal_na_allowed(mean_neighbors(b, w, "l", "d")[idx_lp], correct_mean_neighbors_l_d)
  expect_equal_na_allowed(mean_neighbors(b, w, "r", "d")[idx_lp], correct_mean_neighbors_r_d)
  expect_equal_na_allowed(mean_neighbors(b, w, "b", "d")[idx_lp], correct_mean_neighbors_b_d)
  expect_equal_na_allowed(mean_neighbors(b, w, "a", "d")[idx_lp], correct_mean_neighbors_a_d)
})
