% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scplot.R
\name{scplot}
\alias{scplot}
\title{Plot Synthetic Control Point Estimates and Prediction Interval}
\usage{
scplot(
  result,
  fig.path = NULL,
  fig.name = NULL,
  fig.format = "png",
  e.out = TRUE,
  joint = FALSE,
  col.treated = "black",
  col.synth = "mediumblue",
  label.xy = NULL,
  plot.range = NULL,
  x.ticks = NULL,
  event.label = NULL,
  plot.specs = NULL,
  save.data = NULL
)
}
\arguments{
\item{result}{a class 'scest' object, obtained by calling \code{\link{scest}}, or a class
'scpi' object, obtained by calling \code{\link{scpi}}.}

\item{fig.path}{a string indicating the path where the plot(s) should be saved.}

\item{fig.name}{a string indicating the name of the plot(s). If multiple plots will be saved the command automatically
generates a numeric suffix to avoid overwriting them.}

\item{fig.format}{a string indicating the format in which the plot(s) should be saved.}

\item{e.out}{a logical specifying whether out-of-sample uncertainty should be included in the plot(s).}

\item{joint}{a logical specifying whether simultaneous prediction intervals should be included in the plot(s). It requires \code{e.out = TRUE}.}

\item{col.treated}{a string specifying the color for the treated unit series. Find the full list at \url{http://sape.inf.usi.ch/quick-reference/ggplot2/colour}.}

\item{col.synth}{a string specifying the color for the synthetic unit series. Find the full list at \url{http://sape.inf.usi.ch/quick-reference/ggplot2/colour}.}

\item{label.xy}{a character list with two elements indicating the name of the axes
(eg. label.xy = list(x.lab = "Year", y.lab = "GDP growth (\%)")).}

\item{plot.range}{a numeric array indicating the time range of the plot(s).}

\item{x.ticks}{a numeric list containing the location of the ticks on the x axis.}

\item{event.label}{a list containing a character object ('lab') indicating the label of the event and
a numeric object indicating the height of the label in the plot.}

\item{plot.specs}{a list containing some specifics to be passed to ggsave (eg. img.width, img.height, dpi)}

\item{save.data}{a character specifying the name and the path of the saved dataframe containing the processed data used
to produce the plot.}
}
\value{
\item{plots}{a list containing standard ggplot object(s) that can be used for further customization.}
}
\description{
The command plots the actual pre-treatment and post-treatment series of the treated
unit and the estimated counterfactual synthetic control unit with corresponding prediction intervals.
Prediction intervals can take into account either in-sample uncertainty only or in-sample and
out-of-sample uncertainty using the techniques developed in to \insertCite{cattaneo2021methodological-JASA;textual}{scpi} and
\insertCite{cattaneo2025methodological-RESTAT;textual}{scpi}.
The input object should come from the command \code{\link{scest}} or from the command \code{\link{scpi}}.

Companion \href{https://www.stata.com/}{Stata} and \href{https://www.python.org/}{Python} packages are described in
\insertCite{cattaneo2025software-JSS;textual}{scpi}.

Companion commands are:  \link{scdata} and \link{scdataMulti} for data preparation in the single and multiple treated unit(s) cases, respectively,
\link{scest} for point estimation, \link{scpi} for inference procedures, and \link{scplotMulti} for plots with multiple treated units.

Related Stata, R, and Python packages useful for inference in SC designs are described in the following website:

\href{ https://nppackages.github.io/scpi/}{ https://nppackages.github.io/scpi/}

For an introduction to synthetic control methods, see \insertCite{abadie2021UsingSyntheticControls;textual}{scpi} and references therein.
}
\examples{

data <- scpi_germany

df <- scdata(df = data, id.var = "country", time.var = "year",
             outcome.var = "gdp", period.pre = (1960:1990),
             period.post = (1991:2003), unit.tr = "West Germany",
             unit.co = setdiff(unique(data$country), "West Germany"),
             constant = TRUE, cointegrated.data = TRUE)

result <- scest(df, w.constr = list(name = "simplex", Q = 1))

scplot(result)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{scdata}}, \code{\link{scdataMulti}}, \code{\link{scest}}, \code{\link{scpi}}, \code{\link{scplotMulti}}
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Yingjie Feng, Tsinghua University. \email{fengyj@sem.tsinghua.edu.cn}.

Filippo Palomba, Princeton University (maintainer). \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}.
}
