% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scqe.1cfull}
\alias{scqe.1cfull}
\title{Stability controlled quasi-experiment (scqe) for 1 cohort case, full data}
\usage{
scqe.1cfull(treatment, outcome, delta, min_delta, max_delta, alpha = 0.05, ...)
}
\arguments{
\item{treatment}{Binary or continuous vector corresponding (usually) to 0,1
(no treatment or treatment) for each observation.}

\item{outcome}{Continuous vector representing the outcome for each
observation.}

\item{delta}{Single value or vector of possible values for change in
average non-treatment outcome between cohorts (if applicable).}

\item{min_delta}{Minimum delta. Optional, not used if \code{delta} is supplied.}

\item{max_delta}{Maximum delta. Optional, not used if \code{delta} is supplied.}

\item{alpha}{Numeric alpha for confidence interval (default is alpha = 0.05).}

\item{...}{Extra optional arguments.}
}
\value{
scqe object of class "scqe." Returns results table for the 1 cohort, full data case.
}
\description{
This function returns the scqe estimates and confidence intervals for the
1 cohort case (ie there is not 'post' input) when the user inputs full data.
}
\examples{
set.seed(1234)
post = c(rep(0,100), rep(1,100))
tx = c(rep(0, 100), rbinom(n = 100, prob = 0.27, size = 1))
y = rbinom(n = 200, prob = 0.1 + 0.02 * post - 0.05 * tx, size = 1)

# One cohort, full data
scqe.1cohort.full = scqe(treatment = tx, outcome = y,
                         delta=seq(from = -0.1, to = 0.1, by = 0.05))
plot(scqe.1cohort.full)
summary(scqe.1cohort.full)



}
