# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

allocate_into_modules <- function(resid_array, resid_var, prior_indicator, k_, update_order, prior_baseline, prior_weight) {
    .Call(`_scregclust_allocate_into_modules`, resid_array, resid_var, prior_indicator, k_, update_order, prior_baseline, prior_weight)
}

#' Perform the computations for thresholded Jaccard distance
#'
#' @details
#' This function is optimized for sparse matrices and computes the pairwise
#' Jaccard distances between the rows of the input matrix. Note that the
#' actual distance is not saved. Instead, a threshold (`eps`) is supplied
#' and an indicator matrix is returned, with a one indicating that the
#' distance is smaller than `eps` (equivalently, the Jaccard similarity
#' is larger than `1 - eps`).
#'
#' @param gs a list of integer vectors, one for each row, giving the column
#'           indices of the non-zero elements of the row or `NULL` if the
#'           whole row is empty.
#' @param eps an upper bound on the Jaccard distance (`1 - eps` becomes a
#'            lower bound on the Jaccard similarity)
#'
#' @return A list with row and column indices in the #row x #row indicator
#'         matrix specifying which rows in the original matrix had a distance
#'         of at most `eps`.
#'
#' @keywords internal
jaccard_indicator_comp <- function(gs, eps) {
    .Call(`_scregclust_jaccard_indicator_comp`, gs, eps)
}

#' ADMM algorithm for solving the group-penalized least squares problem
#'
#' Implements estimation of the coop-lasso problem.
#'
#' @param y Target (n x m)
#' @param x Design matrix (n x p)
#' @param lambda Penalization parameter
#' @param weights A specific weight for each group (typically this is
#'                `sqrt(group size)`).
#' @param beta_0 Initial value for coefficients, allowing for warm start.
#'               Can be set to NULL, which results in the initial `beta`
#'               being a zero matrix.
#' @param rho_0 Initial ADMM step-size
#' @param alpha_0 Initial ADMM relaxation parameter
#' @param n_update Number of steps in-between updates of the
#'                 step-size/adaptation parameters
#' @param eps_corr Lower bound for the correlation in the step-size
#'                 update steps
#' @param max_iter Maximum number of iterations
#' @param eps_rel Relative tolerance for convergence check
#' @param eps_abs Absolute tolerance for convergence check
#' @param verbose Whether or not information about the optimization process
#'                should be printed to the terminal
#'
#' @return A list containing
#'     \item{beta}{The coefficients at convergence}
#'     \item{iterations}{Number of iterations}
#'
#' @references
#' Xu et al. (2017) Adaptive relaxed ADMM: Convergence theory and
#' practical implementation. DOI 10.1109/CVPR.2017.765
#'
#' @keywords internal
coop_lasso <- function(y, x, lambda, weights, beta_0 = NULL, rho_0 = 0.2, alpha_0 = 1.5, n_update = 2L, eps_corr = 0.2, max_iter = 1000L, eps_rel = 1e-8, eps_abs = 1e-12, verbose = FALSE) {
    .Call(`_scregclust_coop_lasso`, y, x, lambda, weights, beta_0, rho_0, alpha_0, n_update, eps_corr, max_iter, eps_rel, eps_abs, verbose)
}

#' Compute NNLS coefficients
#'
#' Computes non-negative least squares coefficients with a matrix
#' right hand side.
#'
#' @param x Coefficient matrix (p x n matrix)
#' @param y Right hand side (p x m matrix)
#' @param eps Convergence tolerance
#' @param max_iter Maximum number of iterations
#'
#' @return A list containing
#'  \item{beta}{The estimated coefficient matrix}
#'  \item{iterations}{A vector containing the number of iterations needed
#'                    for the `i`-th column in `y` in the `i`-th entry.}
#'
#' @references
#' Duy Khuong Nguyen and Tu Bao Ho. Accelerated anti-lopsided algorithm
#' for nonnegative least squares. International Journal of Data Science
#' and Analytics, 3(1):23–34, 2017.
#'
#' Adapted from <https://github.com/khuongnd/nnls_antilopsided>
#'
#' @keywords internal
coef_nnls <- function(x, y, eps = 1e-12, max_iter = 1000L) {
    .Call(`_scregclust_coef_nnls`, x, y, eps, max_iter)
}

#' Allocate 3d-array and fill with matrix along first dimension
#'
#' @param input the matrix of size `n_obs x n_genes`
#' @param n_cl the size of the three-dimensional array's first dimension
#'
#' @return The allocated and filled array of size `n_cl x n_obs x n_genes`
#'
#' @keywords internal
alloc_array <- function(input, n_cl) {
    .Call(`_scregclust_alloc_array`, input, n_cl)
}

#' Reset input 3d-array by filling matrix along first dimension
#'
#' @param arr The 3d-array of dimension `n_cl x n_obs x n_genes`
#' @param input The matrix of size `n_obs x n_genes`
#'
#' @keywords internal
reset_array <- function(arr, input) {
    invisible(.Call(`_scregclust_reset_array`, arr, input))
}

