% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{redist2015}
\alias{redist2015}
\title{Redistribution of wealth}
\format{
A data frame with 305 rows and 12 variables:
\describe{
\item{id}{unique ID number for each participant}
\item{gender}{only "male" or "female" could be answered by the looks of it}
\item{age}{participant age in years}
\item{income}{yearly household income (in units of $1,000)}
\item{pol_att}{political leaning from 1="Extremely Liberal" to 9="Extremely Conservative"}
\item{PD_mean}{estimate average household income in the general US population}
\item{PD_gini}{GINI index computed for a subjective distribution of wealth in the general US population. The GINI index is a measure of wealth inequality; higher numbers mean more inequality}
\item{PD_fair}{Answer to the question "To what extent do you feel that household incomes are fairly--unfairly distributed across the US population?" on a scale from 1="Extremely Fair" to 9 = "Extremely Unfair".}
\item{PD_sat}{Answer to the question "How satisfied--dissatisfied are you with the way in which household incomes are distributed across the US population?" on a scale from 1="Extremely satisfied" to 9="Extremely dissatisfied".}
\item{SC_mean}{estimate average household income in the participant's social circles}
\item{SC_gini}{(subjective) inequality in the participant's social circles}
\item{redist}{support for wealth redistribution policies (average of four items, higher scores indicate stronger support).}
}
}
\source{
\url{https://osf.io/3mftr/}. See also Dawtry, Rael J., Robbie M. Sutton, and Chris G. Sibley. 2015. “Why Wealthier People Think People Are Wealthier, and Why It Matters: From Social Sampling to Attitudes to Redistribution.” Psychological Science 26 (9): 1389–1400. \doi{10.1177/0956797615586560}.
}
\usage{
redist2015
}
\description{
It is generally found that wealthy people tend to be more opposed to policies to reduce wealth inequalities. This may be unsurprising from a classical economic standpoint, because the material burden of the redistribution of wealth will fall on wealthier people. Wealthier people are also more likely than poorer people to adopt political ideologies that oppose redistribution policies. Dawtry, Sutton, and Sibley (2015) investigated whether, in addition to such factors, “social-sampling processes” lead wealthier people to oppose redistribution policies. Social sampling is the idea that people (partly) base inferences on their social surroundings. Wealthier people tend to live in more affluent areas and move in wealthier social circles. This may bias their view of the world, where wealthier people estimate the general population to be wealthier (with less of a gap between the wealthy and the poor) than it really is.
}
\details{
In Experiment 1a of Dawtry, Sutton, and Sibley (2015), they assessed income and opinions for n=305 online U.S. participants recruited via Amazon’s Mechanical Turk.
}
\keyword{datasets}
