% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is-ct.R
\name{is_term}
\alias{is_term}
\alias{is_code}
\title{Is a code or term in a code list?}
\usage{
is_term(term, clst_code)

is_code(code, clst_code)
}
\arguments{
\item{term}{A character vector of terms (e.g. \code{"TENMW102"}).}

\item{clst_code}{A character vector of codes referring to SDTM terminology
codelists (e.g. \code{"C141657"}).}

\item{code}{A character vector of C-codes (e.g. \code{"C174106"}).}
}
\value{
A \code{logical} vector, where \code{TRUE} indicates that \code{term} is a
controlled terminology term within the \code{clst_code} provided, and \code{FALSE},
otherwise.
}
\description{
\code{\link[=is_code]{is_code()}} and \code{\link[=is_term]{is_term()}} evaluate whether query codes or terms are part of
the SDTM controlled terminology within the context of a code list.
}
\examples{
is_term(term = "TENMW101", clst_code = "C141657")

# Note that the clst_code term itself (`"TENMW1TC"`) is not part of its own
# code list (`"C141657"`).
is_term(term = "TENMW1TC", clst_code = "C141657")

# `is_term()` is vectorized over `term` and `clst_code`
is_term(term = c("TENMW101", "TENMW104"), clst_code = "C141657")

is_code(code = "C174106", clst_code = "C141657")

# Note that the code list code itself (`"C141657"`) is not part of its own
# code list (`"C141657"`).
is_code(code = "C141657", clst_code = "C141657")

# `is_code()` is vectorized over `code` and `clst_code`
is_code(code = c("C174106", "C141701"), clst_code = "C141657")

}
