% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeacn_ds_disctx_covid.R
\name{check_ae_aeacn_ds_disctx_covid}
\alias{check_ae_aeacn_ds_disctx_covid}
\title{Check for COVID-19 AE with DRUG WITHDRAWN action without "ADVERSE EVENT" for DS Trt Discon}
\usage{
check_ae_aeacn_ds_disctx_covid(
  AE,
  DS,
  covid_terms = c("COVID-19", "CORONAVIRUS POSITIVE")
)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AETERM, AEDECOD,
AESTDTC, AEACNx}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSSPID, DSCAT, DSDECOD}

\item{covid_terms}{A length >=1 vector of AE terms identifying COVID-19 (case does not matter)}
}
\value{
boolean value if check returns 0 obs, otherwise return subset dataframe.
}
\description{
This checks for a COVID-19 AE reported with Action Taken
(AEACN*==DRUG WITHDRAWN) but without a corresponding DS record indicating
DS.DSDECOD with "ADVERSE EVENT" on any Treatment Discontinuation
form. This relies on DSSPID with the string "DISCTX" when DSCAT ==
"DISPOSITION EVENT" to select Treatment Discontinuation records in DS,
as DSSCAT typically includes a text string referring to specific study
drug(s).
}
\examples{

AE <- data.frame(
    STUDYID = 1,
    USUBJID = c(1,2,3,1,2,3),
    AESTDTC = '2020-05-05',
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE",rep("other AE",4)),
    AEDECOD = c("COVID-19", "CORONAVIRUS POSITIVE", rep("OTHER AE",4)),
    AEACN = c("DRUG WITHDRAWN", rep("DOSE NOT CHANGED",5)),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

DS <- data.frame(
 USUBJID = c(1,1,2,3,4),
 DSSPID  = 'XXX-DISCTX-XXX',
 DSCAT   = "DISPOSITION EVENT",
 DSDECOD = "OTHER REASON",
 DSSEQ = c(1,2,1,1,1),
 stringsAsFactors = FALSE
)

# expect fail
check_ae_aeacn_ds_disctx_covid(AE, DS)


AE2 <- data.frame( 
    AEACN1 =  rep(NA, nrow(AE)),
    AEACN2 = c("DRUG WITHDRAWN", rep("DOSE NOT CHANGED", nrow(AE)-1)),
    AEACN3 = c("DRUG WITHDRAWN", rep("DOSE NOT CHANGED", nrow(AE)-1)),
    AEACN4 = "",
    stringsAsFactors = FALSE
)
AE2 <- cbind(AE, AE2) 
AE2$AEACN <- "MULTIPLE" 

# expect fail
check_ae_aeacn_ds_disctx_covid(AE2, DS)

DS[1, "DSDECOD"] <- 'ADVERSE EVENT'
# this passes, one form with DSDECOD = "ADVERSE EVENT"
## NOTE: This may be a false negative if study-specific data collection 
##       requires >1 record with DSDECOD = "ADVERSE EVENT" and not just one record
check_ae_aeacn_ds_disctx_covid(AE2, DS)

# expect pass
check_ae_aeacn_ds_disctx_covid(AE, DS)


# non-required variable is missing
DS$DSSEQ <- NULL
check_ae_aeacn_ds_disctx_covid(AE, DS)

# required variable is missing 
DS$DSSPID <- NULL
check_ae_aeacn_ds_disctx_covid(AE, DS)


}
\seealso{
Other COVID: 
\code{\link{check_ae_aeacnoth_ds_stddisc_covid}()},
\code{\link{check_dv_ae_aedecod_covid}()},
\code{\link{check_dv_covid}()}
}
\author{
Sarwan Singh
}
\concept{COVID}
\keyword{COVID}
