% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aedthdtc_aesdth.R
\name{check_ae_aedthdtc_aesdth}
\alias{check_ae_aedthdtc_aesdth}
\title{Check AEs with AEDTHDTC value but AESDTH not "Y"}
\usage{
check_ae_aedthdtc_aesdth(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Event SDTM dataset with variables USUBJID, AEDTHDTC,
AESDTH, AEDECOD, AETERM, and AESTDTC}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for AE entries with an AEDTHDTC (death date)
value and AESDTH not equal to "Y"
}
\examples{


AE <- data.frame(
USUBJID = c(1:7), 
AEDECOD = c(letters[1:5], "", NA), 
AETERM = letters[1:7],
AESDTH = "Y",
AEDTHDTC = "2020-01-02",
AESTDTC = c(1:7),
AESPID = "FORMNAME-R:5/L:5XXXX",
stringsAsFactors=FALSE)

# expect pass
check_ae_aedthdtc_aesdth(AE)
check_ae_aedthdtc_aesdth(AE,preproc=roche_derive_rave_row)

# expect fail 
AE1 <- AE
AE1$AESDTH[3] <- "N"
check_ae_aedthdtc_aesdth(AE1)
check_ae_aedthdtc_aesdth(AE1,preproc=roche_derive_rave_row)

# expect fail with AESDTH = NA
AE2 <- AE
AE2$AESDTH[4] <- NA
check_ae_aedthdtc_aesdth(AE2)
check_ae_aedthdtc_aesdth(AE2,preproc=roche_derive_rave_row)

# non-required variable missing
AE2$AESPID <- NULL
check_ae_aedthdtc_aesdth(AE2)
check_ae_aedthdtc_aesdth(AE2,preproc=roche_derive_rave_row)

# required variable missing 
AE2$AESDTH <- NULL
check_ae_aedthdtc_aesdth(AE2)
check_ae_aedthdtc_aesdth(AE2,preproc=roche_derive_rave_row)



}
\author{
Shumei Chi
}
