% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeout.R
\name{check_ae_aeout}
\alias{check_ae_aeout}
\title{Check for inconsistency between AE outcome (AEOUT) and death date (AEDTHDTC)}
\usage{
check_ae_aeout(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDTHDTC, AEOUT}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for AEs with Death date(AEDTHDTC) but outcome
(AEOUT) is not FATAL and conversely AEs with no death date (AEDTHDTC) but
outcome (AEOUT) is fatal
}
\examples{

AE <- data.frame(
    USUBJID = 1:8,
    AEDTHDTC = c(NA, "NA", "2015-03-12", "2017-01-22", "1999-11-07","",NA, "2020-01-01"),
    AEOUT = c("", "", "","FATAL","RECOVERED/RESOLVED","FATAL","FATAL", NA),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

check_ae_aeout(AE)
check_ae_aeout(AE,preproc=roche_derive_rave_row)

AE$AEDTHDTC <- NULL
check_ae_aeout(AE)

AE$AEOUT <- NULL
check_ae_aeout(AE)

}
\author{
Shumei Chi
}
