% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeout_aeendtc_nonfatal.R
\name{check_ae_aeout_aeendtc_nonfatal}
\alias{check_ae_aeout_aeendtc_nonfatal}
\title{Check for non-fatal AEs with inconsistent AEOUT and AEENDTC}
\usage{
check_ae_aeout_aeendtc_nonfatal(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AETERM, AESTDTC, AEENDTC, AEOUT}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Check for inconsistency between AE outcome (AEOUT) and
AE end date (AEENDTC) for non-fatal AEs (based on AEOUT). AE flagged if AEENDTC
not populated when AEOUT is "RECOVERED/RESOLVED", "RECOVERED/RESOLVED WITH
SEQUELAE". AE also flagged if AEENDTC is populated when AEOUT is
"UNKNOWN", "NOT RECOVERED/NOT RESOLVED", "RECOVERING/RESOLVING".
}
\examples{

AE <- data.frame(
USUBJID = 1:10,
AETERM  = "AE",
AESTDTC = c(NA, "NA", "2015-03-09", "2010-10", "2017-01-20",   "1999-11-02",
        "",     NA,                   "2017-08-20",          "2014-12-01"),
AEENDTC = c(NA, "NA", "2015-03-12", "2010-10", "2017-01-22",   "1999-11-07",
        "",     NA,                   "2017-09-01",          "2015-01-01"),
AEOUT   = c("", "",   "",           "",        "NOT RECOVERED",
"RECOVERED/RESOLVED","FATAL","RECOVERED/RESOLVED", "RECOVERING/RESOLVING","UNKNOWN"),
AESPID  = "FORMNAME-R:13/L:13XXXX",
stringsAsFactors = FALSE
)

check_ae_aeout_aeendtc_nonfatal(AE)
check_ae_aeout_aeendtc_nonfatal(AE,preproc=roche_derive_rave_row)

AE$AEENDTC <- NULL
check_ae_aeout_aeendtc_nonfatal(AE)

AE$AEOUT <- NULL
check_ae_aeout_aeendtc_nonfatal(AE)

}
\author{
Jennifer Lomax
}
