% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aesdth_aedthdtc.R
\name{check_ae_aesdth_aedthdtc}
\alias{check_ae_aesdth_aedthdtc}
\title{Check AEs with AESDTH of "Y" but No AEDTHDTC Value}
\usage{
check_ae_aesdth_aedthdtc(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Event SDTM dataset with variables USUBJID, AEDTHDTC,
AESDTH, AETERM, AEDECOD and AESTDTC}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for AE entries with AESDTH of "Y"
but no AEDTHDTC (death date) value
}
\examples{


AE <- data.frame(
USUBJID = c(1:7), 
AEDECOD = c(letters[1:5], "", NA), 
AETERM = letters[1:7],
AESDTH = c(NA, rep("", 4), "Y", "Y"),
AEDTHDTC = c(1:5, "2020", "2020-01-02"),
AESTDTC = c(1:7),
AESPID = "FORMNAME-R:5/L:5XXXX",
stringsAsFactors=FALSE)

# expect pass
check_ae_aesdth_aedthdtc(AE)
check_ae_aesdth_aedthdtc(AE,preproc=roche_derive_rave_row)

# expect fail 
AE1 <- AE
AE1$AEDTHDTC[3] <- NA
AE1$AESDTH[3] <- "Y"

check_ae_aesdth_aedthdtc(AE1)
check_ae_aesdth_aedthdtc(AE1,preproc=roche_derive_rave_row)

# expect fail 
AE2 <- AE1
AE2$AEDTHDTC[4] <- ""
AE2$AESDTH[4] <- "Y"

check_ae_aesdth_aedthdtc(AE2)
check_ae_aesdth_aedthdtc(AE2,preproc=roche_derive_rave_row)

# non-required variable missing
AE2$AESPID <- NULL
check_ae_aesdth_aedthdtc(AE2)
check_ae_aesdth_aedthdtc(AE2,preproc=roche_derive_rave_row)

# required variable missing 
AE2$AESDTH <- NULL
check_ae_aesdth_aedthdtc(AE2)
check_ae_aesdth_aedthdtc(AE2,preproc=roche_derive_rave_row)

}
\author{
Shumei Chi
}
