% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aestdtc_after_dd.R
\name{check_ae_aestdtc_after_dd}
\alias{check_ae_aestdtc_after_dd}
\title{Check for AE dates occurring after death date}
\usage{
check_ae_aestdtc_after_dd(AE, DS, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Event SDTM dataset with variables USUBJID,
AEDTHDTC, AESTDTC, AEDECOD, AETERM, AESPID (optional)}

\item{DS}{Disposition SDTM dataset with variables USUBJID,
DSSTDTC, DSDECOD, DSTERM, DSSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for AE dates that occur after death date
}
\examples{

AE <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 AEDTHDTC = c(rep("", 4), "2016-01-01"),
                 AESTDTC = rep("2016-01-01", 5),
                 AEDECOD = c("","", rep("Myocarditis",3)),
                 AETERM = c("INJURY", rep("MYOCARDITIS", 4)),
                 AESPID = "FORMNAME-R:19/L:19XXXX",
                 stringsAsFactors = FALSE)

DS <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 DSSTDTC = rep("2016-01-02", 5),
                 DSDECOD = c(LETTERS[1:4], "death"),
                 DSSPID = "XXX-R:0",
                 DSTERM = letters[1:5],
                 stringsAsFactors = FALSE)

check_ae_aestdtc_after_dd(AE,DS)

AE$AESTDTC[1] <- "2016-01-03"
AE$USUBJID[1] <- AE$USUBJID[5]

check_ae_aestdtc_after_dd(AE, DS,preproc=roche_derive_rave_row)

AE$AESPID <- NULL
check_ae_aestdtc_after_dd(AE, DS)

DS$DSSPID <- NULL
check_ae_aestdtc_after_dd(AE, DS)

AE$AESTDTC <- NULL
check_ae_aestdtc_after_dd(AE, DS)

}
\author{
Nina Ting Qi
}
