% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_death_ds_discon.R
\name{check_ae_death_ds_discon}
\alias{check_ae_death_ds_discon}
\title{Check if death in AE then there should be a study discon form}
\usage{
check_ae_death_ds_discon(AE, DS, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDTHDTC, AESDTH, AEOUT}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSCAT, DSSCAT}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This checks that if death is indicated in AE via
AEDTHDTC/AESDTH/AEOUT (as well as grade 5 AE if AETOXGR exists) then
there should be a study discontinuation record indicated by DS.DSSCAT
}
\examples{

AE <- data.frame(
 STUDYID = rep(1,6),
 USUBJID = 1:6,
 AEDTHDTC = c(NA,"2020-01-01",NA,NA,NA,NA),
 AESDTH = c(NA,NA,"Y",NA,NA,NA),
 AEOUT = c(NA,NA,NA,"FATAL",NA,NA),
 AETOXGR = c(NA,NA,NA,NA,"5",NA),
 AESPID="FORMNAME-R:2/L:2XXXX"
)

DS <- data.frame(
 STUDYID = 1,
 USUBJID = 1:3,
 DSCAT="DISPOSITION EVENT",
 DSSCAT=c("STUDY DISCON",
 "STUDY DISCON",
 "STUDY COMPLETION/EARLY DISCONTINUATION")
)

check_ae_death_ds_discon(AE,DS)
check_ae_death_ds_discon(AE,DS,preproc=roche_derive_rave_row)

DS$DSSCAT = NULL

check_ae_death_ds_discon(AE,DS)

}
\author{
Sara Bodach
}
