% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_fatal.R
\name{check_ae_fatal}
\alias{check_ae_fatal}
\title{Check for death variable consistency when AEOUT=="FATAL"}
\usage{
check_ae_fatal(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDECOD,
AESTDTC, AEDTHDTC, AEOUT, AESDTH}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for consistency in AESDTH, AEDTHDTC, and
AETOXGR (if applicable) when AEOUT is 'FATAL'.  Note, this check expects
AE grade/severity variables to be populated for either all records or none.
In a case where both AETOXGR and AESEV exist and some records are supposed
to have AETOXGR populated while others have AESEV (ie the two variables are
mutually exclusive) then this check will likely return false positives.
}
\examples{

# AETOXGR, no AESEV

AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = "01JAN2017",
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEOUT = "FATAL",
 AEDTHDTC = c("01FEB2017",NA,"02FEB2017","03FEB2017",NA),
 AESDTH = c("Y","Y","N","Y",NA),
 AETOXGR = c("5","5","5",NA,NA),
 AESPID = "FORMNAME-R:12/L:2XXXX",
 stringsAsFactors = FALSE
)

check_ae_fatal(AE)
check_ae_fatal(AE,preproc=roche_derive_rave_row)

AE$AETOXGR <- NULL
check_ae_fatal(AE)

AE$AEDECOD <- NULL
check_ae_fatal(AE)


# AESEV, no AETOXGR

 AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = "01JAN2017",
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEOUT = "FATAL",
 AEDTHDTC = c("01FEB2017","02FEB2017","03FEB2017","04FEB2017",NA),
 AESDTH = c("Y","Y","N","Y",NA),
 AESEV = c("SEVERE","MILD","SEVERE",NA,NA),
 AESPID = "FORMNAME-R:12/L:2XXXX",
 stringsAsFactors = FALSE
)

check_ae_fatal(AE)
check_ae_fatal(AE,preproc=roche_derive_rave_row)

AE$AESEV <- NULL
check_ae_fatal(AE)

# Both AESEV and AETOXGR have non-missing values

AE <- data.frame(
 USUBJID = 1:7,
 AESTDTC = "01JAN2017",
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5","AE6","AE7"),
 AEOUT = "FATAL",
 AEDTHDTC = c("01FEB2017",NA,"02FEB2017","03FEB2017",NA,"04FEB2017","05FEB2017"),
 AESDTH = c("Y","Y","N","Y",NA,"Y","Y"),
 AESEV = c("SEVERE","MILD","SEVERE",NA,NA,"MILD","SEVERE"),
 AETOXGR = c("5","5","5",NA,NA,"1","5"),
 AESPID = "FORMNAME-R:12/L:2XXXX",
 stringsAsFactors = FALSE
)

check_ae_fatal(AE)
check_ae_fatal(AE,preproc=roche_derive_rave_row)


# Neither AESEV or AETOXGR

AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = "01JAN2017",
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEOUT = "FATAL",
 AEDTHDTC = c("01FEB2017",NA,"02FEB2017","03FEB2017",NA),
 AESDTH = c("Y","Y","N","Y",NA),
 AESPID = "FORMNAME-R:12/L:2XXXX",
 stringsAsFactors = FALSE
)

check_ae_fatal(AE)

# AETOXGR exists but unmapped AESEV

 AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = "01JAN2017",
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEOUT = "FATAL",
 AEDTHDTC = c("01FEB2017",NA,"02FEB2017","03FEB2017",NA),
 AESDTH = c("Y","Y","N","Y",NA),
 AESEV = rep(NA,5),
 AETOXGR = c("5","5","5",NA,NA),
 AESPID = "FORMNAME-R:12/L:2XXXX",
 stringsAsFactors = FALSE
)

check_ae_fatal(AE)
check_ae_fatal(AE,preproc=roche_derive_rave_row)

# AETOXGR and AESEV exist, by both are unmapped

 AE <- data.frame(
 USUBJID = 1:5,
 AESTDTC = "01JAN2017",
 AEDECOD = c("AE1","AE2","AE3","AE4","AE5"),
 AEOUT = "FATAL",
 AEDTHDTC = c("01FEB2017",NA,"02FEB2017","03FEB2017",NA),
 AESDTH = c("Y","Y","N","Y",NA),
 AESEV = NA,
 AETOXGR = NA,
 AESPID = "FORMNAME-R:12/L:2XXXX",
 stringsAsFactors = FALSE
)

check_ae_fatal(AE)
check_ae_fatal(AE,preproc=roche_derive_rave_row)

}
\author{
Aldrich Salva
}
