% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dd_ae_aeout_aedthdtc.R
\name{check_dd_ae_aeout_aedthdtc}
\alias{check_dd_ae_aeout_aedthdtc}
\title{Check if there is a death date and AEOUT='FATAL' agreement}
\usage{
check_dd_ae_aeout_aedthdtc(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDTHDTC,
AEDECOD, AESTDTC and AEOUT}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for AE death dates if AEOUT='FATAL' and for the
reverse, i.e if there is an AE death date, then AEOUT should have the value
"FATAL".
}
\examples{

AE <- data.frame(
 USUBJID = 1:3,
 AEDTHDTC = c("2020-01-01","2020-01-02","2020-01-03"),
 AEDECOD = 1:3,
 AESTDTC = 1:3,
 AEOUT = rep("FATAL", 3),
 AESPID = "FORMNAME-R:19/L:19XXXX",
 stringsAsFactors = FALSE
)

# pass
check_dd_ae_aeout_aedthdtc(AE)

# fail - 1 case (AEDTHDTC not populated but AEOUT == FATAL)
AE1 <- AE
AE1[3, "AEDTHDTC"] <- NA
check_dd_ae_aeout_aedthdtc(AE1)
check_dd_ae_aeout_aedthdtc(AE1,preproc=roche_derive_rave_row)

# pass -- even though AEDTHDTC populated 
AE2 <- AE
AE2[1, "AEOUT"] <- NA
check_dd_ae_aeout_aedthdtc(AE2)
check_dd_ae_aeout_aedthdtc(AE2,preproc=roche_derive_rave_row)

# 2 cases 
AE[3, "AEDTHDTC"] <- NA
AE[1, "AEOUT"] <- NA
check_dd_ae_aeout_aedthdtc(AE)
check_dd_ae_aeout_aedthdtc(AE,preproc=roche_derive_rave_row)

# 2 cases 
AE[1, "AEOUT"] <- 'NOT RECOVERED/NOT RESOLVED'
check_dd_ae_aeout_aedthdtc(AE)
check_dd_ae_aeout_aedthdtc(AE,preproc=roche_derive_rave_row)

# non-critical variable missing
AE$AESPID <- NULL
check_dd_ae_aeout_aedthdtc(AE)
check_dd_ae_aeout_aedthdtc(AE,preproc=roche_derive_rave_row)

# critical variables are missing
AE$AEDTHDTC <- NULL
AE$USUBJID <- NULL
check_dd_ae_aeout_aedthdtc(AE)
check_dd_ae_aeout_aedthdtc(AE,preproc=roche_derive_rave_row)

}
\author{
Joel Laxamana
}
