% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_usubjid_ae_usubjid.R
\name{check_dm_usubjid_ae_usubjid}
\alias{check_dm_usubjid_ae_usubjid}
\title{Check patients in the DM dataset who do not have records in the AE dataset}
\usage{
check_dm_usubjid_ae_usubjid(DM, AE, DS, EX)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variable USUBJID}

\item{AE}{Adverse Events SDTM dataset with variable USUBJID}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSSTDTC, DSDECOD}

\item{EX}{Exposure SDTM dataset with variables USUBJID, EXDOSE, EXSTDTC,
EXTRT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for patients in the DM dataset who do not have
records in the AE dataset, and obtains first treatment start date and earliest
death date for these patients
}
\examples{
USUBJID<- c(1:10)
DM=data.frame(USUBJID)
AE=data.frame(USUBJID)
AE$USUBJID[3]=NA
AE$USUBJID[8]=NA
AE$USUBJID[10]=NA

EX <- data.frame(
USUBJID = c(1:8, 6, 8, 10, 10, 10, 10),
EXOCCUR = rep("Y", times=14),
EXDOSE = rep(c(1,2), times=7),
EXSTDTC = c(rep("2012-01-01", 10),"2012-02-04","2012-02-04", "", "2012-02-07"),
EXTRT = "GDC",
stringsAsFactors=FALSE
)

DS <- data.frame(
USUBJID = c(2,8,8),
DSDECOD = rep("DEATH", times=3),
DSSTDTC = c("2012-12-01", NA, "2013-07-01"),
stringsAsFactors=FALSE
)
check_dm_usubjid_ae_usubjid(DM, AE, DS, EX)

EX$EXOCCUR[3]="N"

check_dm_usubjid_ae_usubjid(DM, AE, DS, EX)

EX$EXOCCUR=NULL

check_dm_usubjid_ae_usubjid(DM, AE, DS, EX)

}
\author{
Vani Nimbal
}
