% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_dsdecod_dsstdtc.R
\name{check_ds_dsdecod_dsstdtc}
\alias{check_ds_dsdecod_dsstdtc}
\title{Check DS with death record but no death date}
\usage{
check_ds_dsdecod_dsstdtc(DS)
}
\arguments{
\item{DS}{Disposition SDTMv dataset with variables USUBJID, DSDECOD,
DSSCAT and DSSTDTC}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the test failed
}
\description{
This check looks for patients in DS who have a record indicating
death but no corresponding record with death date in DS.
For example, "Survival Follow Up" records often have no death dates, so for
a data cut to be applied properly, you have to impute that missing
death date from another record where its not missing (e.g. Study Discon form)
}
\examples{

DS <- data.frame(STUDYID = rep(1, 5),
                 USUBJID = c(1, 1, 1, 2, 3),
                 DSDECOD = c("DEATH", "DEATH", rep("", 3)),
                 DSSCAT = LETTERS[1:5],
                 DSSTDTC = c("", "2016-01-01", "", "", "2016-01-02"),
                 stringsAsFactors = FALSE)

check_ds_dsdecod_dsstdtc(DS)

DS$DSSTDTC[2] <- ""

check_ds_dsdecod_dsstdtc(DS)


}
\author{
Will Harris
}
