% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_dsscat.R
\name{check_ds_dsscat}
\alias{check_ds_dsscat}
\title{Check for patients with more than one study discontinuation records}
\usage{
check_ds_dsscat(DS)
}
\arguments{
\item{DS}{Disposition SDTM dataset with variables USUBJID,DSSCAT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for patient who has more than one study
discontinuation records
}
\examples{

DS <- data.frame(
 USUBJID = c(rep(1,3),rep(2,3),rep(3,3)),
 DSSCAT= rep(c("STUDY DISCONTINUATION", "ADVERSE EVENT", "PROTOCOL"),3),
 stringsAsFactors=FALSE
)
check_ds_dsscat(DS)

DS$DSSCAT[8] = "STUDY DISCONTINUATION"
check_ds_dsscat(DS)

DS$DSSCAT = NULL
check_ds_dsscat(DS)


}
\author{
Madeleine Ma
}
