% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ec_sc_lat.R
\name{check_ec_sc_lat}
\alias{check_ec_sc_lat}
\title{Check if Study Drug is not administered in the Study Eye}
\usage{
check_ec_sc_lat(EC, SC)
}
\arguments{
\item{EC}{Subject Exposure Dataset with variables
USUBJID, ECCAT (if available), ECLOC, ECMOOD, ECLAT, ECSTDY, VISIT, ECSTDTC, ECOCCUR, ECROUTE}

\item{SC}{Subject Characteristics Dataset for Ophtha Study with variables
USUBJID, SCTEST, SCTESTCD, SCCAT, SCORRES, SCDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
Check if Study Drug is not administered in the Study Eye.
1.> Subset Exposure dataset (EC) for only ocular Study Drug Administration records,
and pass the check if there are none. If EC.ECCAT variable is available then remove records
containing EC.ECCAT = “FELLOW”. If EC.ECCAT variable is not available then include all records,
assuming drug administration is collected for study eye only.
2.> Subset Subject Characteristics dataset (SC) for only Study Eye Selection
3.> Compare Exposure dataset laterality (EC.ECLAT) with Subject Characteristics dataset laterality
(SC.SCORRES - OS = LEFT, OD = RIGHT) and report if there is any mismatch.
}
\examples{

sc <- data.frame(USUBJID  = c(1,1,1,2,2,2),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " "),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", ""),
                 SCCAT    = c("STUDY EYE SELECTION", "STUDY EYE SELECTION", "",
                              "STUDY EYE SELECTION", "STUDY EYE SELECTION", ""),
                 SCORRES  = c("LEFT", "OS", "", "RIGHT", "OD", ""),
                 SCDTC    = "2021-01-01",
                 stringsAsFactors = FALSE)

ec <- data.frame(USUBJID = c(1,1,1,1,1,2,2,2,2,2,2),
                 ECCAT   = c("Fellow", "Study", "Study", "Study", "StudY",
                             "Fellow", "Fellow", "STUDY", "STUDY", "STUDY", ""),
                 ECMOOD  = rep("Performed", 11),
                 ECLOC   = rep("Eye", 11),
                 ECLAT   = c("LEFT", "Left", "left", "LEFT", "LEFT", "RIGHT",
                             "right", "right", "RIGHT", "RIGHT", "right"),
                 ECSTDY  = c(1, 28, 56, 84, 112, 1, 28, 56, 84, 112, 140),
                 VISIT   = c("Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 1", "Week 4", "Week 8", "Week 12", "Week 16", "Week 20"),
                 ECSTDTC = c("2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                             "2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                             "2021-06-01"),
                 ECOCCUR = "Y",
                 ECROUTE = "INTRAVITREAL",
                 stringsAsFactors=FALSE)

check_ec_sc_lat(SC=sc, EC=ec)

sc <- data.frame(USUBJID  = c(1,1,1,2,2,2),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " "),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", ""),
                 SCCAT    = c("STUDY EYE SELECTION", "STUDY EYE SELECTION", "",
                              "STUDY EYE SELECTION", "STUDY EYE SELECTION", ""),
                 SCORRES  = c("LEFT", "OS", "", "RIGHT", "OD", ""),
                 SCDTC    = "2021-01-01",
                 stringsAsFactors = FALSE)

ec <- data.frame(USUBJID = c(1,1,1,1,1,2,2,2,2,2,2),
                 ECCAT   = c("Fellow", "Study", "Study", "Study", "StudY",
                             "Fellow", "Fellow", "STUDY", "STUDY", "STUDY", ""),
                 ECMOOD  = rep("Performed", 11),
                 ECLOC   = rep("Eye", 11),
                 ECLAT   = c("LEFT", "Left", "left", "LEFT", "RIGHT", "RIGHT",
                             "right", "right", "RIGHT", "RIGHT", "left"),
                 ECSTDY  = c(1, 28, 56, 84, 112, 1, 28, 56, 84, 112, 140),
                 VISIT   = c("Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 1", "Week 4", "Week 8", "Week 12", "Week 16", "Week 20"),
                 ECSTDTC = c("2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                             "2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                             "2021-06-01"),
                 ECOCCUR = "Y",
                 ECROUTE = "OPHTHALMIC",
                 stringsAsFactors=FALSE)

check_ec_sc_lat(SC=sc, EC=ec)

sc <- data.frame(USUBJID  = c(1,1,1,2,2,2,3),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Focus of Study-Specific Interest"),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", "", "FOCID"),
                 SCCAT    = c("STUDY EYE SELECTION", "STUDY EYE SELECTION", "",
                              "STUDY EYE SELECTION",
                              "STUDY EYE SELECTION", "", "STUDY EYE SELECTION"),
                 SCORRES  = c("LEFT", "OS", "", "RIGHT", "OD", "", "RIGHT"),
                 SCDTC    = "2021-01-01",
                 stringsAsFactors = FALSE)

ec <- data.frame(USUBJID = c(1,1,1,1,1,2,2,2,2,2,2),
                 ECMOOD  = "Performed",
                 ECLOC   = "Eye",
                 ECLAT   = c("LEFT", "Left", "left", "LEFT", "RIGHT", "RIGHT",
                             "right", "right", "RIGHT", "RIGHT", "left"),
                 ECSTDY  = c(1, 28, 56, 84, 112, 1, 28, 56, 84, 112, 140),
                 VISIT   = c("Week 1", "Week 4", "Week 8", "Week 12", "Week 16",
                             "Week 1", "Week 4", "Week 8", "Week 12", "Week 16", "Week 20"),
                 ECSTDTC = c("2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                             "2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01",
                             "2021-06-01"),
                 ECOCCUR = c("Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "N"),
                 stringsAsFactors=FALSE)

check_ec_sc_lat(SC=sc, EC=ec)



}
\author{
Monarch Shah (HackR 2021 Team Eye)
}
