% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_eg_egdtc_visit_ordinal_error.R
\name{check_eg_egdtc_visit_ordinal_error}
\alias{check_eg_egdtc_visit_ordinal_error}
\title{Check that all ECG datetimes are earlier than last
visit's (possible datetime data entry error)}
\usage{
check_eg_egdtc_visit_ordinal_error(EG)
}
\arguments{
\item{EG}{ECG Test Results SDTM dataset with variables USUBJID, VISITNUM, VISIT, EGDTC, EGSTAT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if
the test failed
}
\description{
This check identifies EGDTC values that are
earlier than last visit's. Unscheduled visits are excluded.
}
\examples{

# No case
EG<- data.frame(USUBJID = 101:102,
                EGDTC=rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                "2017-01-15T10:25", "2017-01-20T08:25", "2017-01-25T08:25"), 2),
                VISITNUM=rep(1:5,2),
                VISIT=rep(c("Screening", "Cycle 1", "Cycle 2",
                "Cycle 3","UNschedUled"),2),
                EGSTAT="",
                stringsAsFactors=FALSE)
check_eg_egdtc_visit_ordinal_error(EG)

# Cases with earlier datetime
EG$EGDTC[EG$USUBJID == 101 & EG$VISIT == "Cycle 3"] <- "2017-01-10T08:25"
EG$EGDTC[EG$USUBJID == 102 & EG$VISIT == "Cycle 1"] <- "2017-01-01T06:25"
check_eg_egdtc_visit_ordinal_error(EG)

# Cases with duplicated datetime
EG$EGDTC[EG$USUBJID == 101 & EG$VISIT == "Cycle 3"] <- "2017-01-15T10:25"
EG$EGDTC[EG$USUBJID == 102 & EG$VISIT == "Cycle 2"] <- "2017-01-01T06:25"
check_eg_egdtc_visit_ordinal_error(EG)

# Not checking duplicates
EG<- data.frame(USUBJID = rep("101",6),
                EGDTC=rep("2017-01-01T08:25", 6),
                VISITNUM=rep(1:2,3),
                VISIT=rep("Screening",6),
                EGSTAT="",
                stringsAsFactors=FALSE)

check_eg_egdtc_visit_ordinal_error(EG)

}
\author{
James Zhang
}
