% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_dup.R
\name{check_ex_dup}
\alias{check_ex_dup}
\title{Check for duplicate EX records}
\usage{
check_ex_dup(EX)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID, EXTRT, EXDOSE, EXSTDTC, EXSTDTC.
VISIT is optional.}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for duplicate treatment records in EX
}
\examples{

EX <- data.frame(
 USUBJID = rep(1,2),
 EXTRT = rep(1,2),
 EXDOSE = rep(1,2),
 EXSTDTC = rep(1,2),
 EXOCCUR = "Y"
)
check_ex_dup(EX)

EX$EXOCCUR <- NULL

check_ex_dup(EX)

EX$EXDOSE <- NULL

check_ex_dup(EX)

# test with sample data without duplicates

EX <- data.frame(
USUBJID = 1:2,
EXTRT = 1:2,
EXDOSE = 1:2,
EXSTDTC = 1:2,
EXOCCUR = "Y"
)

check_ex_dup(EX)

EX = rbind(EX,EX)

check_ex_dup(EX)

# check non existing vars

EX$EXTRT <- NULL
EX$EXOCCUR <- NULL

check_ex_dup(EX)


}
\author{
Fang Yuan
}
