% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exdose_pos_exoccur_no.R
\name{check_ex_exdose_pos_exoccur_no}
\alias{check_ex_exdose_pos_exoccur_no}
\title{Check for EXDOSE>0 When EXOCCUR is not "Y"}
\usage{
check_ex_exdose_pos_exoccur_no(EX, drug = NULL)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID, EXTRT, EXSTDTC,
EXOCCUR and EXDOSE}

\item{drug}{Drug name for EXTRT; used to subset the dataset.
Default value is NULL (i.e. no filtering by drug)}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the test failed
}
\description{
This checks looks for EXDOSE values greater than 0 when
EXOCCUR is not "Y". It could be for a specified drug/treatment, or for
all drugs/treatments in the dataset.
}
\examples{

EX <- data.frame(
 USUBJID = 1:5,
 EXSTDTC = rep("2017-01-01",5),
 EXTRT   = c(rep("TRT A",2),rep("TRT B",3)),
 EXOCCUR = c(".","", "N", "N", "Y"),
 EXDOSE  = 0:4,
 VISIT = "VISIT 1",
 stringsAsFactors = FALSE
)

check_ex_exdose_pos_exoccur_no(EX)

check_ex_exdose_pos_exoccur_no(EX, drug = "TRT A")
check_ex_exdose_pos_exoccur_no(EX, drug = "TRT B")

EX$EXDOSE = NULL

check_ex_exdose_pos_exoccur_no(EX)

}
\author{
Sara Bodach
}
