% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exstdtc_visit_ordinal_error.R
\name{check_ex_exstdtc_visit_ordinal_error}
\alias{check_ex_exstdtc_visit_ordinal_error}
\title{Check that all EX start dates are earlier than last
visit's (possible datetime data entry error)}
\usage{
check_ex_exstdtc_visit_ordinal_error(EX)
}
\arguments{
\item{EX}{Exposure dataset with variables USUBJID, EXTRT, VISITNUM, VISIT, EXDTC, optional variable EXOCCUR}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies EXSTDTC values that are
earlier than last visit's. Unscheduled visits are excluded.
}
\examples{

# no case
EX <- data.frame(USUBJID = 101:102,
                EXTRT = rep(c("A", "B"), 5),
                EXSTDTC = rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                 "2017-01-15T10:25","2017-01-20T08:25","2017-01-25T08:25"), 2),
                VISITNUM = rep(1:5,2),
                VISIT = rep(c("Cycle 1", "Cycle 2", "Cycle 3", "Cycle 4", "uNscheDuledd"), 2),
                stringsAsFactors = FALSE)
check_ex_exstdtc_visit_ordinal_error(EX)

# adding cases with earlier date
EX$EXSTDTC[EX$USUBJID == 101 & EX$VISIT == "Cycle 4"] <- "2017-01-10T08:25"
EX$EXSTDTC[EX$USUBJID == 102 & EX$VISIT == "Cycle 2"] <- "2017-01-01T06:25"
check_ex_exstdtc_visit_ordinal_error(EX)

# adding cases with duplicated date
EX$EXSTDTC[EX$USUBJID == 101 & EX$VISIT == "Cycle 5"] <- "2017-01-10T08:25"
EX$EXSTDTC[EX$USUBJID == 102 & EX$VISIT == "Cycle 3"] <- "2017-01-01T06:25"
check_ex_exstdtc_visit_ordinal_error(EX)

}
\author{
James Zhang
}
