% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_lbstresn_missing.R
\name{check_lb_lbstresn_missing}
\alias{check_lb_lbstresn_missing}
\title{Check missing standard lab values (LBSTRESN/LBSTRESC)}
\usage{
check_lb_lbstresn_missing(LB, preproc = identity, ...)
}
\arguments{
\item{LB}{Lab SDTM dataset with variables USUBJID, LBTESTCD, LBDTC, LBORRES,
LBORRESU, LBSTRESN, LBSTRESC, VISIT (optional), LBSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing standardized finding (LBSTRESN/LBSTRESC)
when original finding (LBORRES) is not missing
}
\examples{

LB <- data.frame(
 USUBJID = c("Patient 1","Patient 2","Patient 3"),
 LBTEST   = "Test A",
 LBTESTCD   = "TA",
 LBDTC   = "2017-01-01",
 LBORRES = c("5","6","7"),
 LBSTRESC = c("5","6","7"),
 LBORRESU = rep("mg",3),
 LBSTRESN  = c(5,6,NA),
 stringsAsFactors=FALSE
 )

check_lb_lbstresn_missing(LB)

LB$LBSTRESC[3] = ""
check_lb_lbstresn_missing(LB)

LB$LBSTRESC[1] = ""
check_lb_lbstresn_missing(LB)

LB$VISIT = "SCREENING"
check_lb_lbstresn_missing(LB)

LB$LBSPID= "FORMNAME-R:2/L:2XXXX"
check_lb_lbstresn_missing(LB,preproc=roche_derive_rave_row)

LB$LBSTRESN = NULL
check_lb_lbstresn_missing(LB)

LB$LBSTRESC = NULL
check_lb_lbstresn_missing(LB)

}
\author{
Madeleine Ma
}
