% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_oe_bcva_4m_vs_1m_req.R
\name{check_oe_bcva_4m_vs_1m_req}
\alias{check_oe_bcva_4m_vs_1m_req}
\title{Check if 1m BCVA test is completed per BCVA 4m result}
\usage{
check_oe_bcva_4m_vs_1m_req(OE)
}
\arguments{
\item{OE}{Ophtho Dataset with variables USUBJID, OECAT, OESCAT, OETSTDTL, OESTRESN, OESTAT, OELAT,
OERESCAT, VISIT, OEDTC, OEDY}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This ophthalmology function is to check if BCVA 1m test is done per BCVA 4m result.
Patient, Visits, Laterality where Low Vision Tests were done are excluded from this check.
1> If 4m test total <= 19 and 1m test is not done.
2> If 4m test total >= 20 and 1m test is performed
Above two conditions will be outputted in the final result data frame, which includes USUBJID, VISIT,
OEDTC, OELAT, BCVA_4M_TOTAL, BCVA_1M_TOTAL, ISSUE.
Please note that this check will assume that the BCVA 1m and 4m total are accurate and they happen on the same day.
If they are happening on different dates, such records will be removed and not checked.
}
\examples{
OE_1m_done <- data.frame(
  USUBJID = "1",
  OECAT = "BEST CORRECTED VISUAL ACUITY",
  OETSTDTL = c(rep("TESTING DISTANCE: 4M", 4), rep("TESTING DISTANCE: 1M", 3)),
  OESCAT = c(rep("", 3), "TOTAL", rep("", 2), "TOTAL"),
  OESTAT = rep("", 7),
  OERESCAT = c("ROW 1 - SNELLEN 20/200",
               "ROW 2 - SNELLEN 20/160",
               "ROW 3 - SNELLEN 20/125",
               "",
               "ROW 1 - SNELLEN 20/200",
               "ROW 2 - SNELLEN 20/160",
               ""),
  VISIT = "WEEK 1",
  VISITNUM = 5,
  OEDTC = "2020-06-01",
  OEDY = 8,
  OELOC = "EYE",
  OELAT = "LEFT",
  OESTRESN = c(9, 9, 3, 21, 3, 2, 5)
)
check_oe_bcva_4m_vs_1m_req(OE_1m_done)

OE_1m_not_done <- data.frame(
  USUBJID = "1",
  OECAT = "BEST CORRECTED VISUAL ACUITY",
  OETSTDTL = "TESTING DISTANCE: 4M",
  OESCAT = c(rep("", 3), "TOTAL"),
  OESTAT = "",
  OERESCAT = c("ROW 1 - SNELLEN 20/200",
               "ROW 2 - SNELLEN 20/160",
               "ROW 3 - SNELLEN 20/125",
               ""),
  VISIT = "WEEK 1",
  VISITNUM = 5,
  OEDTC = "2020-06-01",
  OEDY = 8,
  OELOC = "EYE",
  OELAT = "LEFT",
  OESTRESN = c(5, 5, 2, 12)
)
check_oe_bcva_4m_vs_1m_req(OE_1m_not_done)

}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Rosemary Li (HackR 2021 Team Eye)
}
\concept{OPHTH}
\keyword{OPHTH}
