% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pr_missing_month.R
\name{check_pr_missing_month}
\alias{check_pr_missing_month}
\title{Check for procedure dates with year and day known but month unknown}
\usage{
check_pr_missing_month(PR, preproc = identity, ...)
}
\arguments{
\item{PR}{Procedures SDTM dataset with variables USUBJID, PRTRT, PRSTDTC,
PRENDTC (optional), PRSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for partial missing dates in PR Procedures
start date and end date, if end date exists. If the day of the month is
known, the month should be known.
}
\examples{

PR <- data.frame(
 USUBJID = 1:3,
 PRTRT = c("Surgery Name","Procedure Name","Procedure"),
 PRSTDTC = c("2017-01-01","2017---01","2017-01-02"),
 PRENDTC = c("2017-02-01","2017-03-01","2017---01"),
 PRSPID = "/F:SURG-D:12345-R:1",
 PRCAT = "Form 1",
 stringsAsFactors=FALSE
)

check_pr_missing_month(PR)

check_pr_missing_month(PR,preproc=roche_derive_rave_row)

PR$PRENDTC = NULL
check_pr_missing_month(PR)

}
