% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_vs_sbp_lt_dbp.R
\name{check_vs_sbp_lt_dbp}
\alias{check_vs_sbp_lt_dbp}
\title{Check that DBP is not higher than SBP in VS}
\usage{
check_vs_sbp_lt_dbp(VS)
}
\arguments{
\item{VS}{Vital Signs SDTM dataset with variables USUBJID,VISIT,VSDTC,VSTESTCD,VSSTRESN,VSSPID}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for non-missing diastolic BP is not higher than non-missing systolic BP
}
\examples{

vs <- data.frame(
 STUDYID = 1,
 USUBJID = 1,
 VSSPID = c("1","2","1","2"),
 VISIT = 1,
 VSDTC = c("2010-01-01","2010-01-01","2010-01-01","2010-01-01"),
 VSTESTCD = c("SYSBP","SYSBP",
            "DIABP","DIABP")
            ,
 VSSTRESN = c(80,120,100,80)
 )

 vs0 <- subset(vs, select = c(USUBJID, VSSPID, VSSTRESN))

 check_vs_sbp_lt_dbp(VS=vs)
 check_vs_sbp_lt_dbp(VS=vs0)


}
