% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_all_checks.R
\name{run_all_checks}
\alias{run_all_checks}
\title{Run all data checks in sdtmchecks package using parallel processing}
\usage{
run_all_checks(
  metads = sdtmchecksmeta,
  priority = c("High", "Medium", "Low"),
  type = c("ALL", "ONC", "COVID", "PRO", "OPHTH"),
  verbose = TRUE,
  ncores = 1
)
}
\arguments{
\item{metads}{Metadata to use to execute the checks. The default is the
sdtmchecksmeta dataframe available in the package. This object could
easily be customized, subset, etc.}

\item{priority}{Priority level of data checks, i.e., c("High", "Medium", "Low").
NULL runs all priority levels.}

\item{type}{Type of data checks, i.e., c("ALL", "ONC", "COV", "PRO", "OPHTH").
NULL runs all type.}

\item{verbose}{Whether to display messages while running}

\item{ncores}{Number of cores for parallel processing, with default set
to 1 (sequential)}
}
\value{
list with results from individual data check functions
}
\description{
This function runs all checks in the sdtmchecks package.
It expects SDTM domains saved as dataframe objects in your global environment.
These dataframes should have lowercase names, e.g., dm.
}
\details{
To look up documentation for the data checks in package, please use
command ??sdtmchecks
}
\examples{

# Assuming sdtm datasets are in your global environment
# Note we are only specifying AE and DS here so all unrelated checks wont be run

ae <- data.frame(
    STUDYID = 1,
    USUBJID = c(1,2,3,1,2,3),
    AESTDTC = '2020-05-05',
    AETERM  = c("abc Covid-19", "covid TEST POSITIVE",rep("other AE",4)),
    AEDECOD = c("COVID-19", "CORONAVIRUS POSITIVE", rep("OTHER AE",4)),
    AEACN = c("DRUG WITHDRAWN", rep("DOSE NOT CHANGED",5)),
    AESPID = "FORMNAME-R:13/L:13XXXX",
    stringsAsFactors = FALSE
)

ds <- data.frame(
 USUBJID = c(1,1,2,3,4),
 DSSPID  = 'XXX-DISCTX-XXX',
 DSCAT   = "DISPOSITION EVENT",
 DSDECOD = "OTHER REASON",
 DSSEQ = c(1,2,1,1,1),
 stringsAsFactors = FALSE
)

all_rec<-run_all_checks(metads=sdtmchecksmeta, 
                        verbose=FALSE)
                        
}
\seealso{
Example programs for running data checks
\code{\link{diff_reports}()},
\code{\link{report_to_xlsx}()},
\code{\link{run_check}()}
}
\concept{ex_rpt}
\keyword{ex_rpt}
