% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{truncate_var_strings}
\alias{truncate_var_strings}
\title{Utility function to truncate data in var_name}
\usage{
truncate_var_strings(dt, var_name, trunc_length)
}
\arguments{
\item{dt}{dataset e.g. AE}

\item{var_name}{variable name e.g. AETERM}

\item{trunc_length}{e.g. length the string will be truncated to e.g. 50}
}
\value{
dataset with truncated variable
}
\description{
This function will truncate the strings in variables according to the length specified
}
\examples{

# Testing: no truncation

AE <- data.frame(
 USUBJID = 1:5,
 DOMAIN = "AE",
 AESEQ = 1:5,
 AESTDTC = 1:5,
 AETERM = 1:5,
 AEDECOD = 1:5,
 stringsAsFactors = FALSE
)

truncate_var_strings(AE, var_name = "AETERM", trunc_length = 50)

# Testing: Truncation

AE$AETERM[4] <- "THIS IS A SUPER LONG AE TERM, SO LONG IN FACT THAT ITS OVER 50 CHARACTERS."
AE$AETERM[5] <- "THIS AE TERM IS WAY TOO LONG FOR A NICELY FORMATTED REPORT"

truncate_var_strings(AE, var_name = "AETERM", trunc_length = 50)

}
\seealso{
Reporting-related utility functions
\code{\link{convert_var_to_ascii}()},
\code{\link{create_R_script}()}
}
\author{
Stella Banjo(HackR 2021)
}
\concept{utils_rpt}
\keyword{internal}
\keyword{utils_rpt}
