% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_specification.R
\name{create_mmodel}
\alias{create_mmodel}
\title{Specifying a measurement model.}
\usage{
create_mmodel(..., list = NULL, lv_scaling = "effect", invariance = NULL)
}
\arguments{
\item{...}{Named arguments each representing a latent variable. The arguments
are character vectors containing the variable names the latent variables are measured by.}

\item{list}{List. Each list element represents a latent variable.
List elements are character vectors containing the variable names the latent variables are measured by.}

\item{lv_scaling}{Character vector. Defines the strategy for latent variable scaling.
Default is \code{lv_scaling = "effect"}. Possible strategies are: \code{c("effect", "referent")}.}

\item{invariance}{Not yet implemented.}
}
\value{
Object of classe \code{mmodel}.
}
\description{
Specifying a measurement model.
}
\examples{

mmodel <- create_mmodel(
    A1B1 = "var1",
    A2B1 = "var2",
    A3B1 = "var3",
    A1B2 = "var4",
    A2B2 = "var5",
    A3B2 = "var6",
    lv_scaling = "referent"
)

}
