% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.states}
\alias{sensibo.pod.states}
\title{Get the specified air conditioner (pod) current and previous states.}
\usage{
sensibo.pod.states(pod, n = 10, key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{n}{(integer) The number of states to get (max 20); n=1 will get only the current state.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list with the requested states, starting from the current one.
}
\description{
Get the specified air conditioner (pod) current and previous states.
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Getting the current state of the first pod
## Even if we're asking for the current state only, a list is returned anyway
pod.current <- sensibo.pod.states(pods.id[1], n = 1) 
}
}
