% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datesToDoY.R
\name{datesToDoY}
\alias{datesToDoY}
\title{Mapping phenodates to days of year (DoY)}
\usage{
datesToDoY(
  start = 1,
  end = 12,
  phenodates,
  totalDoY = c(0, cumsum(c(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31)))
)
}
\arguments{
\item{start}{numeric, first month in mapping range. Default is 1.}

\item{end}{numeric, last month in mapping range. Default is 12.}

\item{phenodates}{numeric vector of length 6 containing estimates of phenological
dates (green up, start of season, maturity, senescence, end of season and
dormancy)}

\item{totalDoY}{numeric vector, each entry (except for the first) gives a month's
total number of days}
}
\value{
A \code{data.frame} with variables \code{month} and \code{day}
}
\description{
This function maps estimated phenological dates to days of a year.
}
\details{
Length of \code{start:end} must be equal to \code{length(totalDoY)-1}.
}
\examples{
x <- c(102,140,177,301,339,242)
names(x) <- c("GU", "SoS", "Mat", "Sen", "EoS", "Dor")
datesToDoY(phenodates = x)

}
