% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecFromData.R
\name{vecFromData}
\alias{vecFromData}
\title{Get numeric vector from RData file}
\usage{
vecFromData(
  product = c("MOD13Q1", "independent"),
  data,
  numRow,
  lenPeriod = 23
)
}
\arguments{
\item{product}{character indicating whether \code{data} comes from a \code{MOD13Q1} (default) time series satellite
imagery or from an \code{independent} product.}

\item{data}{a matrix containing measurements of subsets (polygons) of a time series of satellite images. 
\code{nrow} is equal to the number of pixels in the polygon and \code{ncol} is equal 
to the number of images in the time series.}

\item{numRow}{numeric, number of row to extract from \code{data}.}

\item{lenPeriod}{numeric, number of observations per period. Default, 23.}
}
\value{
A list with two components:
\item{mat}{extracted vector in matricial form}
\item{vec}{extracted vector}
}
\description{
Extract a numeric vector from an RData file
}
\details{
Although the first available MOD13Q1 product dates back to 18-02-2000, 
when \code{product="MOD13Q1"} this function assumes that \code{data} contains observations from
01-01-2000 and \code{\link[sephora]{fill_initialgap_MOD13Q1}} is used to impute
the first three missing values of 2000.
}
\seealso{
\code{\link{fill_initialgap_MOD13Q1}}, \code{\link[sephora]{phenopar}}, 
\code{\link[geoTS]{raster_intersect_sp}}, \code{\link{vecToMatrix}}.
}
