% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sepkoski_raw}
\alias{sepkoski_raw}
\title{Sepkoski's marine animal genera compendium (raw)}
\format{
A \code{data.frame} with 35826 rows and 8 variables:
\describe{
\item{phylum}{A character denoting the phylum of the taxon.}
\item{class}{A character denoting the class of the taxon.}
\item{order}{A character denoting the order of the taxon.}
\item{genus}{A character denoting the genus of the taxon.}
\item{FOP}{A character denoting the geological period of first occurrence.}
\item{FOS}{A character denoting the geological stage of last occurrence.}
\item{LOP}{A character denoting the geological period of first occurrence.}
\item{LOS}{A character denoting the geological stage of last occurrence.}
}
}
\source{
{Shanan Peter's 'Sepkoski's Online Genus Database':}
\url{http://strata.geology.wisc.edu/jack/}.
}
\usage{
sepkoski_raw
}
\description{
This dataset is a port of \href{https://www.biodiversitylibrary.org/page/27980221#page/113/mode/1up}{Sepkoski's (2002)}
published compendium of fossil marine animal genera.
This version of the dataset was pulled from Shanan Peters' \href{http://strata.geology.wisc.edu/jack/}{online database}. No changes have been made to any
taxonomic names or first and last appearance data. The definitions of
stage/period abbreviations are provided in \href{https://www.biodiversitylibrary.org/page/27980221#page/113/mode/1up}{Sepkoski's (2002)}, or can
be accessed via the included \link[sepkoski]{interval_table} for convenience.
}
\section{References}{

Sepkoski, J. J. (2002). A compendium of fossil marine animal genera.
\emph{Bulletins of American Paleontology}, 363, pp. 1--560.
}

\keyword{datasets}
