% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_soundSample.R
\name{soundSample}
\alias{soundSample}
\title{Sound sample constructor.}
\usage{
soundSample(wave, rate = 44100)
}
\arguments{
\item{wave}{Numeric vector, wave time series}

\item{rate}{Numeric, sampling rate (default 44100 Hz)}
}
\value{
An object of class 'soundSample'.
}
\description{
Creates a new instance of a 'soundSample' object.
A sound sample can be viewed as a minimalistic version of
an "audio wave" object (see package tuneR for instance).
It is necessarily mono and the wave time series is normalized
between -1 and 1.
}
\examples{
sam <- soundSample(sin(2*pi*seq(0,1,,44100)*440)) # 1-second A (440 Hz)
sam <- soundSample(sin(2*pi*seq(0,1,,44100)*440)+0.1*rnorm(44100)) # 1-second noisy A
}
