% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dev.r
\name{f_dev}
\alias{f_dev}
\title{Calculate negative log-likelihood (deviance) for one antigen:isotype pair and several values of incidence}
\usage{
f_dev(lambda, csdata, lnpars, cond)
}
\arguments{
\item{lambda}{a \link{numeric} vector of incidence parameters, in events per person-year}
}
\value{
a \link{numeric} vector of negative log-likelihoods,
corresponding to the elements of input \code{lambda}
}
\description{
Calculates negative log-likelihood (deviance) for one antigen:isotype pair and several values of incidence (\code{lambda}).
}
\details{
Vectorized version of \code{\link[=f_dev0]{f_dev0()}}; interface with C lib \code{serocalc.so}
}
\examples{
\donttest{
library(dplyr)
library(tibble)

# load in longitudinal parameters
curve_params <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

# load in pop data
xs_data <-
  sees_pop_data_pk_100

#Load noise params
noise_params <- tibble(
  antigen_iso = c("HlyE_IgG", "HlyE_IgA"),
  nu = c(0.5, 0.5),                          # Biologic noise (nu)
  eps = c(0, 0),                             # M noise (eps)
  y.low = c(1, 1),                           # low cutoff (llod)
  y.high = c(5e6, 5e6))                      # high cutoff (y.high)

cur_antibody = "HlyE_IgA"

cur_data =
  xs_data \%>\%
  dplyr::filter(
   .data$catchment == "aku",
   .data$antigen_iso == cur_antibody) \%>\%
  dplyr::slice_head(n = 100)

cur_curve_params =
  curve_params \%>\%
  dplyr::filter(.data$antigen_iso == cur_antibody) \%>\%
  dplyr::slice_head(n = 100)

cur_noise_params =
  noise_params \%>\%
  dplyr::filter(.data$antigen_iso == cur_antibody)

if(!is.element('d', names(cur_curve_params)))
{
  cur_curve_params =
    cur_curve_params \%>\%
    dplyr::mutate(
      alpha = .data$alpha * 365.25,
      d = .data$r - 1)
}

lambdas = seq(.1, .2, by = .01)
f_dev(
    lambda = lambdas,
    csdata = cur_data,
    lnpars = cur_curve_params,
    cond = cur_noise_params
  )
}
}
\keyword{internal}
