% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_stan_data.R
\name{get_foi_index}
\alias{get_foi_index}
\title{Generates Force-of-Infection indexes for heterogeneous age groups}
\usage{
get_foi_index(serosurvey, group_size, model_type)
}
\arguments{
\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{group_size}{Age groups size}

\item{model_type}{Type of the model. Either "age" or "time"}
}
\value{
A Data Frame which describes the grouping of years or ages
(dependent on model) into pieces within which the FoI is assumed constant
when performing model fitting. A single FoI value will be estimated for
ages/years assigned with the same index
}
\description{
Generates a list of integers indexing together the time/age intervals
for which FoI values will be estimated in \link{fit_seromodel}.
The max value in \code{foi_index}  corresponds to the number of FoI values to
be estimated when sampling.
The serofoi approach to fitting serological data currently supposes that FoI
is piecewise-constant across either groups of years or ages, and this
function creates a Data Frame that communicates this grouping to the
Stan model
}
\examples{
data(chagas2012)
foi_index <- get_foi_index(chagas2012, group_size = 25, model_type = "time")
}
