% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfclust-methods.R
\name{fitted.sfclust}
\alias{fitted.sfclust}
\title{Fitted Values for \code{sfclust} Objects}
\usage{
\method{fitted}{sfclust}(object, sample = object$clust$id, sort = FALSE, aggregate = FALSE, ...)
}
\arguments{
\item{object}{An object of class 'sfclust', containing clustering results and models.}

\item{sample}{An integer specifying the clustering sample number for which
the fitted values should be computed. The default is the \code{id} of the
current clustering. The value must be between 1 and the total number
of clustering (membership) samples.}

\item{sort}{Logical value indicating if clusters should be relabel based on number of
elements.}

\item{aggregate}{Logical value indicating if fitted values are desired at cluster
level.}

\item{...}{Additional arguments, currently not used.}
}
\value{
A \code{stars} object with linear predictor fitted values at regions levels. In case
\code{aggregate = TRUE}, the \code{output} produces an \code{stars} objecto at cluster levels.
}
\description{
This function calculates the fitted values for a specific clustering sample in an
\code{sfclust} object, based on the estimated models for each cluster. The fitted
values are computed using the membership assignments and model parameters
associated with the selected clustering sample.
}
\details{
The function first checks if the provided \code{sample} value is valid (i.e., it is
within the range of available clustering samples). If the specified \code{sample}
does not match the current clustering \code{id}, the \code{sfclust} object is updated
accordingly. It then retrieves the membership assignments and cluster models
for the selected sample, calculates the linear predictions for each cluster,
and combines them into a matrix of fitted values.
}
\examples{

\donttest{
library(sfclust)

data(stgaus)
result <- sfclust(stgaus, formula = y ~ f(idt, model = "rw1"), niter = 10,
  nmessage = 1)

# Estimated values ordering clusters by size
df_est <- fitted(result, sort = TRUE)

# Estimated values aggregated by cluster
df_est <- fitted(result, aggregate = TRUE)

# Estimated values using a particular clustering sample
df_est <- fitted(result, sample = 3)
}

}
