% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_3x3_combined.R
\name{sfc_3x3_combined}
\alias{sfc_3x3_combined}
\alias{sfc_expand,sfc_3x3_combined-method}
\alias{draw_rules_3x3_combined}
\title{General 3x3 space-filling curves}
\usage{
sfc_3x3_combined(seed, level = 0, rot = 0L, flip = FALSE)

\S4method{sfc_expand}{sfc_3x3_combined}(p, code = NULL, flip = FALSE)

draw_rules_3x3_combined(flip = FALSE)
}
\arguments{
\item{seed}{The seed sequence. In most cases, the seed sequence is a single base pattern, which can be specified as a single letter, then \code{rot} controls
the initial rotation of the base pattern. It also supports a sequence with more than one base patterns as the seed sequence. In this case,
it can be specified as a string of more than one base letters, then \code{rot} can be set to a single rotation scalar which controls the rotation of the
first letter, or a vector with the same length as the number of base letters.}

\item{level}{Level of the curve. Currently it is restricted to an integer no bigger than 5.}

\item{rot}{Rotation of the seed sequence, measured in the polar coordinate system, in degrees.}

\item{flip}{The same setting as in \code{\link[=sfc_3x3_peano]{sfc_3x3_peano()}} or \code{\link[=sfc_3x3_meander]{sfc_3x3_meander()}}.}

\item{p}{An \code{sfc_3x3_combined} object.}

\item{code}{Ignore. The traverse codes are selected randomly.}
}
\value{
\code{sfc_3x3_combined()} returns an \code{sfc_3x3_combined} object.
}
\description{
General 3x3 space-filling curves
}
\details{
This type of 3x3 curve uses the combintation of base patterns from both the Peano curve and the Meander curve.
On each level, the traverse path is randomly selected.
}
\examples{
draw_multiple_curves(
    sfc_3x3_combined("I", level = 3),
    sfc_3x3_combined("I", level = 3),
    sfc_3x3_combined("I", level = 3),
    nrow = 1
)
draw_rules_3x3_combined()
draw_rules_3x3_combined(flip = TRUE)
}
