% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_4x4_meander.R
\name{sfc_4x4_meander}
\alias{sfc_4x4_meander}
\alias{sfc_expand,sfc_4x4_meander-method}
\alias{draw_rules_4x4_meander}
\title{4x4 space-filling curves in meander type}
\usage{
sfc_4x4_meander(seed, code = integer(0), rot = 0L, flip = FALSE, type = 1L)

\S4method{sfc_expand}{sfc_4x4_meander}(p, code, flip = FALSE)

draw_rules_4x4_meander(type = 1, flip = FALSE)
}
\arguments{
\item{seed}{The seed sequence. In most cases, the seed sequence is a single base pattern, which can be specified as a single letter, then \code{rot} controls
the initial rotation of the base pattern. It also supports a sequence with more than one base patterns as the seed sequence. In this case,
it can be specified as a string of more than one base letters, then \code{rot} can be set to a single rotation scalar which controls the rotation of the
first letter, or a vector with the same length as the number of base letters.}

\item{code}{A vector of the expansion code. The left side corresponds to the higher levels (more to the top-level) of the curve and the right side corresponds to the lower level (more to the bottom-level) of the curve.
The value can be set as a vector e.g. \code{c(1, 2, 1)}, or as a string e.g. \code{"121"}, or as a number e.g. \code{121}.}

\item{rot}{Rotation of the seed sequence, measured in the polar coordinate system, in degrees.}

\item{flip}{The same setting as in \code{\link[=sfc_3x3_peano]{sfc_3x3_peano()}} or \code{\link[=sfc_3x3_meander]{sfc_3x3_meander()}}.}

\item{type}{Which type of rules to use? 1 for \code{\link{SFC_RULES_4x4_MEANDER_1}} and 2 for \code{\link{SFC_RULES_4x4_MEANDER_2}}.}

\item{p}{An \code{sfc_4x4_meander} object.}
}
\value{
\code{sfc_4x4_meander()} returns an \code{sfc_4x4_meander} object.
}
\description{
4x4 space-filling curves in meander type
}
\details{
It is an extension of the 3x3 Meander curves to mode 4. For simplicity, it only supports \code{I/R/L} base patterns.
}
\examples{
draw_multiple_curves(
    sfc_4x4_meander("I", "11", type = 1),
    sfc_4x4_meander("I", "12", type = 1),
    sfc_4x4_meander("I", "11", type = 2),
    sfc_4x4_meander("I", "12", type = 2),
    nrow = 2
)
seed = paste(rep(paste0("R", sapply(0:10, function(i) strrep("I", i))), each = 2), collapse="")
sfc_4x4_meander(seed, 1) |> plot()
draw_rules_4x4_meander(type = 1)
draw_rules_4x4_meander(type = 2)
}
