% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_base.R, R/sfc_grob.R
\name{sfc_grob,sfc_base-method}
\alias{sfc_grob,sfc_base-method}
\alias{sfc_grob,sfc_sequence-method}
\alias{sfc_grob}
\alias{plot.sfc_sequence}
\alias{sfc_grob,sfc_nxn-method}
\alias{plot.sfc_nxn}
\alias{sfc_grob,matrix-method}
\title{The graphics object}
\usage{
\S4method{sfc_grob}{sfc_base}(p)

\S4method{sfc_grob}{sfc_sequence}(
  p,
  bases = NULL,
  extend = FALSE,
  title = FALSE,
  closed = FALSE,
  lwd = 4,
  col = NULL,
  ...
)

\method{plot}{sfc_sequence}(
  x,
  bases = NULL,
  grid = FALSE,
  extend = FALSE,
  title = FALSE,
  closed = FALSE,
  ...
)

\S4method{sfc_grob}{sfc_nxn}(
  p,
  bases = p@rules@bases,
  extend = FALSE,
  title = FALSE,
  closed = FALSE,
  ...
)

\method{plot}{sfc_nxn}(x, grid = FALSE, extend = FALSE, title = FALSE, closed = FALSE, ...)

\S4method{sfc_grob}{matrix}(p, title = NULL, closed = FALSE, lwd = 4, col = NULL, ...)
}
\arguments{
\item{p}{The corresponding object.}

\item{bases}{A list of base patterns, normally \code{\link{BASE_LIST}} is used.}

\item{extend}{Whether to add the entry and exit segments?}

\item{title}{Whether to add title on the top of the plot? The title is constructed in the form of \code{initial_seed|expansion_code}, e.g. \code{I|111}.
The value can also be a string.}

\item{closed}{Whether the curve is closed?}

\item{lwd}{Line width.}

\item{col}{Color for segments. If the value is \code{NULL}, it uses the "Spectral" color palettes.}

\item{...}{Other arguments passed to \code{\link[grid:viewport]{grid::viewport()}} or \code{sfc_grob()}.}

\item{x}{The corresponding object.}

\item{grid}{Whether to add grid lines on the plot?}
}
\value{
A \code{\link[grid:grid.grob]{grid::grob()}} object.
}
\description{
The graphics object
}
\details{
If \code{p} is an \code{sfc_sequence} and \code{p} contains base patterns defined in \code{"I/J/R/L/U/B/D/P/Q/C"},
the default \code{\link{BASE_LIST}} is automatically used for \code{bases}. If \code{p} is an \code{sfc_nxn} object, \code{bases}
is already stored in \code{p} and it is passed to this function automatically.
}
\examples{
sfc_grob(BASE_I)
plot(sfc_2x2("I", "11"))
plot(sfc_2x2("I", "11"), extend = TRUE, title = TRUE, grid = TRUE)
plot(sfc_sequence("IIIRRR"))
}
