% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviz.R
\name{sankey_ly}
\alias{sankey_ly}
\title{Sankey Plot with Plotly}
\usage{
sankey_ly(x, cat_cols, num_col, title = NULL)
}
\arguments{
\item{x}{A data.frame input, must have at least two categorical columns and one numeric column}

\item{cat_cols}{A  vector of at least two categorical columns names}

\item{num_col}{A single numeric column name}

\item{title}{Optional, string to pass to plotly layout title function}
}
\description{
Sankey Plot with Plotly
}
\details{
A customized function for data transformation and plotting sankey plot with Plotly
}
\examples{
data("sfo_passengers")

library(dplyr)

d <- sfo_passengers \%>\%
  filter(activity_period >= 202201 & activity_period < 202301)

head(d)

d \%>\%
  filter(operating_airline == "United Airlines") \%>\%
  mutate(terminal = ifelse(terminal == "International", "international", terminal)) \%>\%
  group_by(operating_airline,activity_type_code, geo_summary, geo_region,  terminal) \%>\%
  summarise(total = sum(passenger_count), .groups = "drop") \%>\%
  sankey_ly(cat_cols = c("operating_airline", "terminal","geo_summary",
                         "geo_region", "activity_type_code"),
            num_col = "total",
            title = "Distribution of United Airlines Passengers at SFO During 2022")
}
