% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burst_tj.R
\name{grouping-class}
\alias{grouping-class}
\alias{make_s_group}
\alias{make_c_grouping}
\alias{c.s_group}
\alias{c.c_grouping}
\title{A class to group movement data}
\usage{
make_s_group(x)

make_c_grouping(x = NULL, active_group = NULL)

\method{c}{s_group}(...)

\method{c}{c_grouping}(..., recursive = FALSE)
}
\arguments{
\item{x}{a list containing named grouping variables, one item must be named 'id'. ex: list(id = 1, month = 'may'). For a c_grouping: A list of s_groups or
a list of equal length named vectors which will be combined to create a c_grouping. ex: list(x = 1st_vector, y = 2nd_vector)}

\item{active_group}{a vector of the names of the groups to be considered 'active'.}

\item{...}{objects to be pasted together into a c_grouping}

\item{recursive}{ignored}
}
\description{
This class describes grouping variables for movement data.
The grouping object is composed of a list with named vectors.
One of which must be 'id', this is the id of subject being monitored (commonly animal id in movement data)
Can be any number of groups after that.
}
\details{
A grouping is a list of possible categories to group the data. The 'active group'
of these is the current grouping variables to be considered for analysis. The 'active group' can be any combination of the categories in a burst,
and can change with the use of `active_group()`.

An `s_group` is a single row group. It is a 1xn dimensional list with any length(n) > 1.
Atleast one of the groups must be named 'id' which is the subjects id.

A `c_grouping` is a collection of `s_groups`s, it is a data.frame with dimensions of 1xnrow(data).
One c_grouping has one 'active group' which describes the set of names in each s_group to group the data. When you change the 'active group', calculations and plots change accordingly
to the new grouping levels.

You can create bursts with make_s_group and make_c_grouping.
}
\examples{
# Make a single group
#'
make_s_group(x = list(id = "CJ11", month = 3, height = 10))

# Make a c_grouping
data("raccoon")
raccoon$timestamp <- as.POSIXct(raccoon$timestamp, "EST")
burstz <- list(id = raccoon$animal_id, month = as.POSIXlt(raccoon$timestamp)$mon)
mb1 <- make_c_grouping(x = burstz, active_group = c("id", "month"))
str(mb1)

# Make a multi_burst from many ind_bursts
a <- make_s_group(list(id = 1, year = 2020))
b <- make_s_group(list(id = 1, year = 2020))
c <- make_s_group(list(id = 2, year = 2020))

c(a, b, c)
}
